<?php

namespace App\Filament\Resources\Locations\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class LocationForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('village_id')
                    ->relationship('village', 'name')
                    ->searchable()
                    ->preload()
                    ->required(),
                TextInput::make('name')
                    ->required(),
                Select::make('type')
                    ->options([
                        'mosque' => 'Tempat Ibadah',
                        'school' => 'Sekolah',
                        'hospital' => 'Rumah Sakit',
                        'puskesmas' => 'Puskesmas',
                    ])
                    ->required(),
                TextInput::make('latitude')
                    ->required()
                    ->numeric(),
                TextInput::make('longitude')
                    ->required()
                    ->numeric(),
                FileUpload::make('photo_path')
                    ->directory('locations')
                    ->image(),
            ]);
    }
}
