<?php

namespace App\Filament\Resources\StuntingAreas;

use App\Filament\Resources\StuntingAreas\Pages\CreateStuntingArea;
use App\Filament\Resources\StuntingAreas\Pages\EditStuntingArea;
use App\Filament\Resources\StuntingAreas\Pages\ListStuntingAreas;
use App\Filament\Resources\StuntingAreas\Schemas\StuntingAreaForm;
use App\Filament\Resources\StuntingAreas\Tables\StuntingAreasTable;
use App\Models\StuntingArea;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class StuntingAreaResource extends Resource
{
    protected static ?string $model = StuntingArea::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getNavigationLabel(): string
    {
        return 'Area Stunting';
    }

    public static function getPluralModelLabel(): string
    {
        return 'Area Stunting';
    }

    public static function getModelLabel(): string
    {
        return 'Area Stunting';
    }

    public static function form(Schema $schema): Schema
    {
        return StuntingAreaForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return StuntingAreasTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListStuntingAreas::route('/'),
            'create' => CreateStuntingArea::route('/create'),
            'edit' => EditStuntingArea::route('/{record}/edit'),
        ];
    }
}
